setwd(".")

#load required libraries
library(ggplot2)
library(scales)
library(plyr)

# load the data
load("environment_legislation.RData")

# convert Date of Documents into date format
envLegislation$Date.of.document <- as.Date(envLegislation$Date.of.document, "%Y-%m-%d")

# create variables of the week, month and year of each document
envLegislation$Month <- as.Date(cut(envLegislation$Date.of.document, breaks = "month"))
envLegislation$Week <- as.Date(cut(envLegislation$Date.of.document, breaks = "week", start.on.monday = FALSE)) #set weekly breakpoint to Sunday
envLegislation$Year <- as.Date(cut(envLegislation$Date.of.document, breaks = "year"))

# create plot
envYearlyFrequencies <- count(envLegislation, "Year")
ggplot(data=envYearlyFrequencies, aes(x=Year, y=freq)) +
    geom_bar(stat="identity" ,colour="white", fill="black") +
    theme_bw() +
    annotate("rect", xmin = as.Date("1969-01-01"), xmax = as.Date("1987-01-01"), ymin=-0.5, ymax=32, alpha=.2) +
    annotate("rect", xmin = as.Date("2004-01-01"), xmax = as.Date("2019-01-01"), ymin=-0.5, ymax=32, alpha=.2) +
    geom_smooth(method = "loess", se = F, colour = "green") +
    labs(x = "Year", y= "Legislation Adopted")
